/* **********************************************************************************
 *                			Copyright                         
 *
 *    Copyright  2002 Fonix Coporation. All rights reserved.
 *
 *    This is an unpublished work, and is confidential and proprietary: 
 *    technology and information of Fonix corporation.  No part of this
 *    code may be reproduced, used or disclosed without written consent of 
 *    Fonix corporation in each and every instance.
 * ***********************************************************************************
 *  Rev Name    Date        Description
 *  --- -----   ----------- --------------------------------------------
 *	001	CAB		05/15/2002	Added copyright info
 *	002	MGS		04/14/2003	Fix for Epson Bug 5_3_001
 */

#if !defined OS_PALM && !defined CASIO_SH3
#include <stdio.h>
#endif
#include <string.h>

#include "kernel.h"
#include "tts.h"
#include "cm_def.h"
//#include "ph_def.h"
#include "ph_defs.h"
#include "ph_data.h"
#include "simpleapi.h"
#include "ls_def.h"   
#include "ls_prot.h"
#include "port.h"


extern int cmd_loop(LPTTS_HANDLE_T phTTS,char input);

extern int vtm_main(LPTTS_HANDLE_T phTTS);
extern int ph_main(LPTTS_HANDLE_T phTTS);
extern int lts_main(LPTTS_HANDLE_T phTTS);
extern int cmd_main(LPTTS_HANDLE_T phTTS);
extern void DTSetSampleRate( LPTTS_HANDLE_T phTTS, unsigned int uiSampRate );
#ifndef EPSON_ARM7
extern short cur_packet_number;
extern short max_packet_number;
#endif

#ifndef EPSON_ARM7
#ifndef OS_SYMBIAN
TTS_HANDLE_T hTTS;
LPTTS_HANDLE_T phTTS;
KSD_T Ksd_t;
#else
#include "GlobalDT.h"
#endif
#endif

//typedef unsigned char U8;
#ifndef OS_SYMBIAN
char *g_user_dict;
short *(*g_callback)(short *,long);
#endif


#ifdef _BIGENDIAN_
#define get_long_int(ptr) ((U32)\
                       ((((U8 *)(ptr))[0] << 24)  | \
                        (((U8 *)(ptr))[1] << 16)  | \
                        (((U8 *)(ptr))[2] << 8)  | \
                        (((U8 *)(ptr))[3])))

#else
#define get_long_int(ptr) ((U32)\
                       ((((U8 *)(ptr))[3] << 24)  | \
                        (((U8 *)(ptr))[2] << 16)  | \
                        (((U8 *)(ptr))[1] << 8)  | \
                        (((U8 *)(ptr))[0])))
#endif

#define PC_SAMPLE_RATE 11025
#define MULAW_SAMPLE_RATE 8000

#ifdef DICT_IN_MEMORY
extern const unsigned char main_dict[];

extern const unsigned char sp_main_dict[];
extern const unsigned char us_main_dict[];
extern const unsigned char gr_main_dict[];

extern const unsigned char fr_main_dict[];
//currently there is no italian dictionary
//extern const unsigned char it_main_dict[];
#endif //DICT_IN_MEMORY

extern const short paul[];
extern const short us_paul_tune[];
extern const short fr_paul_tune[];
extern const short default_tune[];
extern const short fr_default_tune[];

extern void us_lts_loop_2(LPTTS_HANDLE_T phTTS,unsigned short *input);
extern void gr_lts_loop_2(LPTTS_HANDLE_T phTTS,unsigned short *input);
extern void fr_lts_loop_2(LPTTS_HANDLE_T phTTS,unsigned short *input);
extern void sp_lts_loop_2(LPTTS_HANDLE_T phTTS,unsigned short *input);
extern void it_lts_loop_2(LPTTS_HANDLE_T phTTS,unsigned short *input);

extern int us_lts_main(LPTTS_HANDLE_T phTTS);
extern int gr_lts_main(LPTTS_HANDLE_T phTTS);
extern int fr_lts_main(LPTTS_HANDLE_T phTTS);
extern int sp_lts_main(LPTTS_HANDLE_T phTTS);
extern int it_lts_main(LPTTS_HANDLE_T phTTS);

extern int us_lts_language_loaded( void );
extern int gr_lts_language_loaded( void );
extern int fr_lts_language_loaded( void );
extern int sp_lts_language_loaded( void );
extern int it_lts_language_loaded( void );

//#ifdef MULTIPLE_LANGUAGES_LOADED
#ifdef NO_INITALIZED_GLOBALS
int ReInit;
#else
int ReInit = 0;
#endif
//#endif
/* ******************************************************************
 *      Function Name: TextToSpeechInit()
 *
 *      Description: 
 *
 *      Arguments:	short *(*callback)(short*,long)
 *					void *user_dict
 *
 *      Return Value: int
 *
 *      Comments:
 *
 * *****************************************************************/
#ifndef OS_SYMBIAN
int TextToSpeechInit(short *(*callback)(short *,long), void *user_dict)
#else
int TextToSpeechInit(short *(*callback)(short *,long, void*), void *user_dict, void *user_data)
#endif
{
	int return_code;

#ifdef MULTIPLE_LANGUAGES_LOADED
	int prevLang = Ksd_t.lang_curr;
	int prevVoice = Ksd_t.last_voice;
#endif //MULTIPLE_LANGUAGES_LOADED

	PKSD_T pKsd_t;
//#ifdef DICT_IN_MEMORY
	char *maindict;
	int i;
//#endif //DICT_IN_MEMORY

	char *dictfilename=NULL;
	char *grdictfilename=NULL;

	memset(&hTTS,0,sizeof(TTS_HANDLE_T));
	memset(&Ksd_t,0,sizeof(KSD_T));
	
	phTTS=&hTTS;
	phTTS->EmbCallbackRoutine=callback;
	phTTS->pKernelShareData=&Ksd_t;
	pKsd_t=&Ksd_t;

	g_callback=callback;

#ifdef DICT_IN_MEMORY
#ifndef OS_SYMBIAN
	g_user_dict=(char *)user_dict;
#else
	gpDT->simpleData.g_user_dict=(char *)user_dict;
#endif
	
	for (i=0; i < MAX_languages; ++i)
	{
		pKsd_t->adic_index[i] = 0;
		pKsd_t->udic_index[i] = 0;
		pKsd_t->fdic_index[i] = 0;
		pKsd_t->adic_data[i] = 0;
		pKsd_t->udic_data[i] = 0;
		pKsd_t->fdic_data[i] = 0;
		pKsd_t->adic_bytes[i] = 0;
		pKsd_t->udic_bytes[i] = 0;
		pKsd_t->fdic_bytes[i] = 0;
		pKsd_t->adic_entries[i] = 0;
		pKsd_t->udic_entries[i] = 0;
		pKsd_t->fdic_entries[i] = 0;
//		pKsd_t->fdic_fc_entry[i]=0;
//		pKsd_t->fdic_fc_entries[i]=0;
	}
	
/*
GL 12/11/1996, set up the language flag pKsd_t->lang_curr
this flag will be used in CMD and phlog.c to pick up the language
depended code
*/
#ifdef MULTIPLE_LANGUAGES_LOADED
	if( !ReInit )
	{
		// order here determines the default order
		if( !us_lts_language_loaded() )
			pKsd_t->lang_curr = LANG_english;
		else if( !fr_lts_language_loaded() )
			pKsd_t->lang_curr = LANG_french;
		else if( !gr_lts_language_loaded() )
			pKsd_t->lang_curr = LANG_german;
		else if( !sp_lts_language_loaded() )
			pKsd_t->lang_curr = LANG_spanish;
		else if( !it_lts_language_loaded() )
			pKsd_t->lang_curr = LANG_italian;
		else
			return (1);
		ReInit = 1;
	}
	else
	{
		pKsd_t->lang_curr = prevLang;
		pKsd_t->last_voice = prevVoice;
	}
#else
	#ifdef ENGLISH_US
		pKsd_t->lang_curr = LANG_english;
	#endif	/* ENGLISH_US */
	
	#ifdef SPANISH_SP
	  pKsd_t->lang_curr = LANG_spanish;
	#endif	/* SPANISH_SP */
	
	#ifdef GERMAN
		pKsd_t->lang_curr = LANG_german;
	#endif	/* GERMAN */
	#ifdef FRENCH
		pKsd_t->lang_curr = LANG_french;
	#endif	/* FRENCH */
	#ifdef ITALIAN
		pKsd_t->lang_curr = LANG_italian;
	#endif	/* ITALIAN */
#endif //MULTIPLE_LANGUAGES_LOADED

	/* user dictionary load */
	if (user_dict)
	{
		pKsd_t->udic_entries[pKsd_t->lang_curr]=get_long_int((char *)user_dict);
		if (pKsd_t->udic_entries[pKsd_t->lang_curr])
		{
			pKsd_t->udic_bytes[pKsd_t->lang_curr]=get_long_int((char *)user_dict+4);
			pKsd_t->udic_index[pKsd_t->lang_curr]=(S32 *)((char *)user_dict+8);
			pKsd_t->udic_data[pKsd_t->lang_curr] = ((unsigned char *)user_dict)+(pKsd_t->udic_entries[pKsd_t->lang_curr]*4)+8;
		}
	}
	
#ifdef MULTIPLE_LANGUAGES_LOADED
	switch( pKsd_t->lang_curr )
	{	
		case LANG_english:
			phTTS->main_lts_loop=(void *)&us_lts_loop_2;
			maindict = (char *)us_main_dict;
			#ifdef _BIGENDIAN_
				dictfilename="\\\\data0\\ttslib\\dtdictus.dic";
			#else
				dictfilename="dtalk_us.nand.dic";
			#endif
//			maindict = NULL;
			break;
		case LANG_french:
			phTTS->main_lts_loop=(void *)&fr_lts_loop_2;
			//maindict = (char *)fr_main_dict;
			#ifdef _BIGENDIAN_
				dictfilename="\\\\data0\\ttslib\\dtdictfr.dic";
			#else
				dictfilename="dtalk_fr.nand.dic";
			#endif
			maindict = NULL;
			break;
		case LANG_german:
			phTTS->main_lts_loop=(void *)&gr_lts_loop_2;
			//maindict = (char *)gr_main_dict;
			#ifdef _BIGENDIAN_
				grdictfilename="\\\\data0\\ttslib\\dtdictgr.dic";
			#else
				grdictfilename="dtalk_gr.nand.dic";
			#endif
			maindict = NULL;
			break;
		case LANG_spanish:
			phTTS->main_lts_loop=(void *)&sp_lts_loop_2;
			//maindict = (char *)sp_main_dict;
			#ifdef _BIGENDIAN_
				dictfilename="\\\\data0\\ttslib\\dtdictsp.dic";
			#else
				dictfilename="dtalk_sp.nand.dic";
			#endif
			maindict = NULL;
			break;

		case LANG_italian:
			phTTS->main_lts_loop=(void *)&it_lts_loop_2;
			//currently there is no italian dictionary
//			maindict = (char *)it_main_dict;
			#ifdef _BIGENDIAN_
				grdictfilename="\\\\data0\\ttslib\\dtdictit.dic";
			#else
				grdictfilename="dtalk_it.nand.dic";
			#endif
			maindict = NULL;
			break;
	}
#else
		maindict = (char *)main_dict;
#endif //MULTIPLE_LANGUAGES_LOADED

	/* main dictionary load */
	if (maindict)
	{
		pKsd_t->fdic_entries[pKsd_t->lang_curr]=get_long_int(maindict);
		if (pKsd_t->fdic_entries[pKsd_t->lang_curr])
		{
			pKsd_t->fdic_bytes[pKsd_t->lang_curr]=get_long_int(maindict+4);
#ifdef CHEESY_DICT_COMPRESSION
			pKsd_t->fdic_fc_entries[pKsd_t->lang_curr]=get_long_int(maindict+8);
			pKsd_t->fdic_fc_entry[pKsd_t->lang_curr]=((S32 *)(maindict+12));
			pKsd_t->fdic_index[pKsd_t->lang_curr]=((S32 *)(maindict+12+(pKsd_t->fdic_fc_entries[pKsd_t->lang_curr]*4)));
			pKsd_t->fdic_data[pKsd_t->lang_curr]=(unsigned char *)(maindict+((pKsd_t->fdic_entries[pKsd_t->lang_curr]+3)*4) + (pKsd_t->fdic_fc_entries[pKsd_t->lang_curr]*4));
#else
			pKsd_t->fdic_index[pKsd_t->lang_curr]=((S32 *)(maindict+8));
			pKsd_t->fdic_data[pKsd_t->lang_curr]=(unsigned char *)(maindict+((pKsd_t->fdic_entries[pKsd_t->lang_curr]+2)*4));
#endif
		}
	}
#else
	#ifdef ENGLISH_US
		pKsd_t->lang_curr = LANG_english;
	#endif	/* ENGLISH_US */

	#ifdef SPANISH_SP
	  pKsd_t->lang_curr = LANG_spanish;
	#endif	/* SPANISH_SP */

	#ifdef GERMAN
		pKsd_t->lang_curr = LANG_german;
	#endif	/* GERMAN */
	#ifdef FRENCH
		pKsd_t->lang_curr = LANG_french;
	#endif	/* FRENCH */
#endif	//DICT_IN_MEMORY	

	if (dictfilename)
	{
		#ifdef _BIGENDIAN_
			pKsd_t->fdicFileHandle[pKsd_t->lang_curr]=(DT_HANDLE)FNX_FOPEN(dictfilename,"r");
		#else
			pKsd_t->fdicFileHandle[pKsd_t->lang_curr]=(DT_HANDLE)FNX_FOPEN(dictfilename,"rb");
		#endif
	}
	if (grdictfilename)
	{
		#ifdef _BIGENDIAN_
			pKsd_t->grfdicFileHandle=(DT_HANDLE)FNX_FOPEN(grdictfilename,"r");
		#else
			pKsd_t->grfdicFileHandle=(DT_HANDLE)FNX_FOPEN(grdictfilename,"rb");
		#endif
	}
		
	pKsd_t->cmd_flush = FALSE;
	pKsd_t->spc_flush = FALSE;
	pKsd_t->halting = FALSE;
	pKsd_t->logflag  = 0;
	/* GL 11/15/1996 set defaulted Spanish to Latin */
	pKsd_t->modeflag = MODE_CITATION;

	if (pKsd_t->lang_curr==LANG_spanish)
		pKsd_t->modeflag|=MODE_EUROPE;
	else if (pKsd_t->lang_curr==LANG_german)
		pKsd_t->modeflag|=MODE_EUROPE;
	else if (pKsd_t->lang_curr==LANG_italian)
		pKsd_t->modeflag|=MODE_EUROPE;
	else if (pKsd_t->lang_curr==LANG_french)
		pKsd_t->modeflag|=MODE_EUROPE;
	else 
		pKsd_t->modeflag&= (~MODE_EUROPE);

	pKsd_t->sayflag = SAY_CLAUSE;
	pKsd_t->pronflag = 0;
	pKsd_t->wbreak = FALSE;
	pKsd_t->text_flush = FALSE;
	pKsd_t->async_change = FALSE;
	pKsd_t->SamplePeriod = 9.07029478458E-5 ;  /* Initialize sample period */
	pKsd_t->spc_pkt_save = NULL_SPC_PACKET;
	pKsd_t->loaded_languages = NULL;           //MVP:05/10/96 Fixed an exception(When DECtalk runs on a machine without audio card)
	pKsd_t->volume=100; //set volume to 100;
	pKsd_t->vol_att=100; //set volume to 100;
	pKsd_t->vol_tone=100; //set volume to 100;

	pKsd_t->phTTS = phTTS;

	phTTS->uiCurrentMsgNumber = 1;
	phTTS->uiLastTextMsgNumber = 0;
	phTTS->uiFlushMsgNumber = 0;
	
	cur_packet_number=0;
	max_packet_number=0;
	
	return_code=vtm_main(phTTS);
	if (return_code)
		return(ERR_ERROR);
	return_code=ph_main(phTTS);
	if (return_code)
		return(ERR_ERROR);
	((PDPH_T)(phTTS->pPHThreadData))->loadspdef=1;
	
	// load_user_dictionary here...
#ifdef MULTIPLE_LANGUAGES_LOADED
	switch( pKsd_t->lang_curr )
	{
		case LANG_english:
			return_code=us_lts_main(phTTS);
			break;
		case LANG_french:
			return_code=fr_lts_main(phTTS);
			break;
		case LANG_german:
			return_code=gr_lts_main(phTTS);
			break;
		case LANG_spanish:
			return_code=sp_lts_main(phTTS);
			break;
		
		case LANG_italian:
			return_code=it_lts_main(phTTS);
			break;
	}

#else
#ifndef DICT_IN_MEMORY
	return_code=lts_main(phTTS);
#endif //DICT_IN_MEMORY
#endif //MULTIPLE_LANGUAGES_LOADED

	if (return_code)
		return(ERR_ERROR);

	return_code=cmd_main(phTTS);
	if (return_code)
		return(ERR_ERROR);
		
	DTSetSampleRate( phTTS, MULAW_SAMPLE_RATE );
	return(ERR_NOERROR);
}

#ifdef MULTIPLE_LANGUAGES_LOADED
/* ******************************************************************
 *      Function Name: TextToSpeechChangeLanguage()
 *
 *      Description: 
 *
 *      Arguments:	int LangId
 *					void *user_dict
 *
 *      Return Value: int
 *
 *      Comments:
 *
 * *****************************************************************/
int TextToSpeechChangeLanguage( int LangId, void *user_dict )
{
	int return_code = -1;
//	int i;
	char *maindict;
	char *dictfilename=NULL;
	char *grdictfilename=NULL;
	PKSD_T pKsd_t = &Ksd_t;
	int prevLang = pKsd_t->lang_curr;

	pKsd_t->lang_curr = LangId;
	//check if language was loaded before switching
	switch( pKsd_t->lang_curr )
	{
		case LANG_english:
			return_code = us_lts_language_loaded( );
			break;
		case LANG_french:
			return_code = fr_lts_language_loaded( );
			break;
		case LANG_german:
			return_code = gr_lts_language_loaded( );
			break;
		case LANG_spanish:
			return_code = sp_lts_language_loaded( );
			break;
		case LANG_italian:
			return_code = it_lts_language_loaded( );
			break;
	}
	if( return_code )
	{
		pKsd_t->lang_curr = prevLang;
		return(ERR_ERROR);
	}

	g_user_dict = (char *)user_dict;

	// set user dictionary for new language
	if (user_dict)
	{
		pKsd_t->udic_entries[pKsd_t->lang_curr] = get_long_int((char *)user_dict);
		if (pKsd_t->udic_entries[pKsd_t->lang_curr])
		{
			pKsd_t->udic_bytes[pKsd_t->lang_curr] = get_long_int((char *)user_dict + 4);
			pKsd_t->udic_index[pKsd_t->lang_curr] = (S32 *)((char *)user_dict) + 8;
			pKsd_t->udic_data[pKsd_t->lang_curr] = ( (char *)user_dict) + (pKsd_t->udic_entries[pKsd_t->lang_curr] * 4 ) + 8;
		}
	}
	else
	{
		pKsd_t->udic_entries[pKsd_t->lang_curr] = 0;
		pKsd_t->udic_bytes[pKsd_t->lang_curr] = 0;
		pKsd_t->udic_index[pKsd_t->lang_curr] = 0;
		pKsd_t->udic_data[pKsd_t->lang_curr] = 0;
	}

	if( prevLang != pKsd_t->lang_curr )
	{
		switch( pKsd_t->lang_curr )
		{	
			case LANG_english:
				phTTS->main_lts_loop=(void *)&us_lts_loop_2;
				#ifdef _BIGENDIAN_
					dictfilename="\\\\data0\\ttslib\\dtdictus.dic";
				#else
					dictfilename="dtalk_us.nand.dic";
				#endif
				maindict = (char *)us_main_dict;
//				maindict = NULL;

				break;
			case LANG_french:
				phTTS->main_lts_loop=(void *)&fr_lts_loop_2;
				//maindict = (char *)fr_main_dict;
				#ifdef _BIGENDIAN_
					dictfilename="\\\\data0\\ttslib\\dtdictsp.dic";
				#else
					dictfilename="dtalk_fr.nand.dic";
				#endif
				maindict = NULL;
				break;
			case LANG_german:
				phTTS->main_lts_loop=(void *)&gr_lts_loop_2;
				//maindict = (char *)gr_main_dict;
				#ifdef _BIGENDIAN_
					grdictfilename="\\\\data0\\ttslib\\dtdictgr.dic";
				#else
					grdictfilename="dtalk_gr.nand.dic";
				#endif
				maindict = NULL;
				break;
			case LANG_spanish:
				phTTS->main_lts_loop=(void *)&sp_lts_loop_2;
				//maindict = (char *)sp_main_dict;
				#ifdef _BIGENDIAN_
					dictfilename="\\\\data0\\ttslib\\dtdictsp.dic";
				#else
					dictfilename="dtalk_sp.nand.dic";
				#endif
				maindict = NULL;
				break;

			case LANG_italian:
				phTTS->main_lts_loop=(void *)&it_lts_loop_2;
				//currently there is no italian dictionary
//				maindict = (char *)it_main_dict;
				maindict = NULL;
				break;
		}

		/* unload the dictionary file */


		/* main dictioanry load */
		if (maindict)
		{
			pKsd_t->fdic_entries[pKsd_t->lang_curr] = get_long_int(maindict);
			if (pKsd_t->fdic_entries[pKsd_t->lang_curr])
			{
				pKsd_t->fdic_bytes[pKsd_t->lang_curr] = get_long_int( maindict + 4 );
#ifdef CHEESY_DICT_COMPRESSION
				pKsd_t->fdic_fc_entries[pKsd_t->lang_curr]=get_long_int(maindict+8);
				pKsd_t->fdic_fc_entry[pKsd_t->lang_curr]=((S32 *)(maindict+12));
				pKsd_t->fdic_index[pKsd_t->lang_curr]=((S32 *)(maindict+12+(pKsd_t->fdic_fc_entries[pKsd_t->lang_curr]*4)));
				pKsd_t->fdic_data[pKsd_t->lang_curr]=(unsigned char *)(maindict+((pKsd_t->fdic_entries[pKsd_t->lang_curr]+3)*4) + (pKsd_t->fdic_fc_entries[pKsd_t->lang_curr]*4));
#else
				pKsd_t->fdic_index[pKsd_t->lang_curr]=((S32 *)(maindict+12));
				pKsd_t->fdic_data[pKsd_t->lang_curr]=(unsigned char *)(maindict+((pKsd_t->fdic_entries[pKsd_t->lang_curr]+2)*4));
#endif
			}
		}
		if(pKsd_t->fdicFileHandle[prevLang])
			FNX_FCLOSE(pKsd_t->fdicFileHandle[prevLang]);

#ifdef DO_THIS_ONLY_ONCE
		if (dictfilename)
		{
			#ifdef _BIGENDIAN_
				pKsd_t->fdicFileHandle[pKsd_t->lang_curr]=(DT_HANDLE)FNX_FOPEN(dictfilename,"r");		
			#else
				pKsd_t->fdicFileHandle[pKsd_t->lang_curr]=(DT_HANDLE)FNX_FOPEN(dictfilename,"rb");
			#endif
		}
		if (grdictfilename)
		{
			#ifdef _BIGENDIAN_
				pKsd_t->grfdicFileHandle=(DT_HANDLE)FNX_FOPEN(grdictfilename,"r");
			#else
				pKsd_t->grfdicFileHandle=(DT_HANDLE)FNX_FOPEN(grdictfilename,"rb");
			#endif
		}
#endif
		// load_user_dictionary here...
		// return_code=lts_main(phTTS);
		switch( pKsd_t->lang_curr )
		{
			case LANG_english:
				return_code=us_lts_main(phTTS);
				break;
			case LANG_french:
				return_code=fr_lts_main(phTTS);
				break;
			case LANG_german:
				return_code=gr_lts_main(phTTS);
				break;
			case LANG_spanish:
				return_code=sp_lts_main(phTTS);
				break;

			case LANG_italian:
				return_code=it_lts_main(phTTS);
				break;
		}
		if( return_code )
			return(ERR_ERROR);

		return_code=cmd_main(phTTS);
		if (return_code)
			return(ERR_ERROR);
	}
	if (pKsd_t->lang_curr==LANG_spanish)
		pKsd_t->modeflag|=MODE_EUROPE;
	else if (pKsd_t->lang_curr==LANG_german)
		pKsd_t->modeflag|=MODE_EUROPE;
	else if (pKsd_t->lang_curr==LANG_italian)
		pKsd_t->modeflag|=MODE_EUROPE;
	else if (pKsd_t->lang_curr==LANG_french)
		pKsd_t->modeflag|=MODE_EUROPE;
	else 
		pKsd_t->modeflag&= (~MODE_EUROPE);
		
	DTSetSampleRate( phTTS, PC_SAMPLE_RATE );

	return(ERR_NOERROR);
}
#endif

/* ******************************************************************
 *      Function Name: TextToSpeechReset()
 *
 *      Description: 
 *
 *      Arguments:	void
 *
 *      Return Value: int
 *
 *      Comments:
 *
 * *****************************************************************/
int TextToSpeechReset(void)
{
	phTTS->pKernelShareData->halting=1;
	return(ERR_NOERROR);
}

/* ******************************************************************
 *      Function Name: TextToSpeechStart()
 *
 *      Description: 
 *
 *      Arguments:	char *input
 *					short *buffer
 *					int output_format
 *
 *      Return Value: int
 *
 *      Comments:
 *
 * *****************************************************************/
int TextToSpeechStart(char *input, short *buffer, int output_format)
{
	int i;
	int oldrate=0;
	int old_sprate=0;
	int oldspeaker=0;
	
// You will only go into this code if you call TextToSpeechReset
	if (phTTS->pKernelShareData->halting)
	{
		oldrate=phTTS->pKernelShareData->uiSampleRate;
		TextToSpeechInit(g_callback,g_user_dict);
		if (oldrate!=phTTS->pKernelShareData->uiSampleRate &&
		    output_format==0)
		{
			DTSetSampleRate( phTTS, MULAW_SAMPLE_RATE );
		}
	}

	((PDPH_T)(phTTS->pPHThreadData))->loadspdef=1;

	phTTS->output_buffer=buffer;
	phTTS->pKernelShareData->halting=0;
	cm_cmd_reset_comm(phTTS->pCMDThreadData, STATE_NORMAL);
	
	switch(output_format)
	{
		case WAVE_FORMAT_1M16:
			memset(buffer,0,71*2);
			if (phTTS->pKernelShareData->uiSampleRate==MULAW_SAMPLE_RATE)
			{
				DTSetSampleRate( phTTS, PC_SAMPLE_RATE );
			}
			break;
		case WAVE_FORMAT_08M16:
			memset(buffer,0,51*2);
			if (phTTS->pKernelShareData->uiSampleRate==PC_SAMPLE_RATE)
			{
				DTSetSampleRate( phTTS, MULAW_SAMPLE_RATE );
			}
			break;
	}

	i=0;
	while (input[i])
	{
		cmd_loop(phTTS,input[i]);
		if (phTTS->pKernelShareData->halting)
		{
			old_sprate=phTTS->pKernelShareData->sprate;
			oldrate=phTTS->pKernelShareData->uiSampleRate;
			oldspeaker=phTTS->pKernelShareData->last_voice;

			TextToSpeechInit(g_callback,g_user_dict);
			phTTS->pKernelShareData->sprate=old_sprate;
			DTSetSampleRate(phTTS, oldrate);
			usevoice (phTTS, oldspeaker);
			phTTS->pKernelShareData->last_voice=oldspeaker;
			phTTS->pKernelShareData->async_voice=oldspeaker;

			return ERR_RESET;
		}
		i++;
	}
	cmd_loop(phTTS,0x0B); // force it
	if (phTTS->pKernelShareData->halting)
	{
		old_sprate=phTTS->pKernelShareData->sprate;
		oldrate=phTTS->pKernelShareData->uiSampleRate;
		oldspeaker=phTTS->pKernelShareData->last_voice;

		TextToSpeechInit(g_callback,g_user_dict);
		phTTS->pKernelShareData->sprate=old_sprate;
		DTSetSampleRate(phTTS, oldrate);
		usevoice (phTTS, oldspeaker);
		phTTS->pKernelShareData->last_voice=oldspeaker;
		phTTS->pKernelShareData->async_voice=oldspeaker;

		return ERR_RESET;
	}
	return ERR_NOERROR;
}


#if !defined DICT_IN_MEMORY && !defined CASIO_SH3
int TextToSpeechUnloadUserDictionary()
{
#ifdef OS_SYMBIAN
	GlobalDTPtr gp = GetGlobalDTPtr();
	 LPTTS_HANDLE_T phTTS = gp->simpleData.phTTS;
#endif
	/********************************************************************/
	/*  Return error if invalid handle.                                 */
	/********************************************************************/
	
	if ( phTTS == 0)
		return( -1 );	

	unload_dictionary((void **)&(phTTS->pKernelShareData->fdic_index[phTTS->pKernelShareData->lang_curr]),
		(void **)&(phTTS->pKernelShareData->fdic_data[phTTS->pKernelShareData->lang_curr]),
		(unsigned int *)&(phTTS->pKernelShareData->fdic_entries[phTTS->pKernelShareData->lang_curr]),
		(unsigned int *)&(phTTS->pKernelShareData->fdic_bytes[phTTS->pKernelShareData->lang_curr]),
		NULL,
		NULL,
		NULL,
		MEMMAP_OFF 
		);
	
	return( 0 );
}
#endif

int TextToSpeechCloseDictionary()
{
 PKSD_T pKsd_t = &Ksd_t;
 int currlang = pKsd_t->lang_curr;
 
 FNX_FCLOSE(pKsd_t->fdicFileHandle[currlang]);
 return 0;
}
